!cpu 6502
!to "rwts",plain
*=$beb0

track=$22 ;track for saving volume ID byte
sector=$0F ;sector for saving volume ID byte
d1s1id=$01 ;volume ID of disk 1 side 1
saveid=$0A ;volume ID of save-game disk

samebyte=$01 ;set to 1 if the replaced byte is the same on all sides
idbyte=$00 ;the value to return in all cases if samebyte=1
sides=$04 ;number of game sides for which we need volume IDs, needed only if samebyte=0
format00=$00 ;set to 1 if format does not specify volume ID
;additional configuration at end of file

    sty $48
    sta $49
    ldy #3 ;requested volume
    lda ($48),y
!if format00=1 {
    bne + ;branch if volume ID specified
    lda #$fe ;force volume 254 if zero
+
} else {
    beq continue ;blind read on zero
}
    tax
!if format00=0 {
    inx      ;watch for volume 254
    cpx #$ff ;set carry according to result
    bcc +
    lda #d1s1id ;use disk 1 side 1 instead
+
}
    sta reqvol+1
!if format00=0 {
    bcs continue ;it was volume 254
}
    lda #0
    sta ($48),y ;allow any volume
!if format00=0 {
    dex
}
    cpx curvol+1 ;or if same volume as last time
    beq continue
    jsr exchange ;returns requested operation
    cmp #4 ;format
    bne readid
    lsr
    sta ($48),y ;convert format to write
    lda #saveid
    sta curvol+1 ;set magic byte
readid
    inc $be3d ;one-byte decode
    jsr callrwts ;returns Y=12, and carry set if error
    dec $be3d ;restore mode
    lda #1 ;restore read mode
    sta reqop ;in case format changed it to write
    bcs setvol ;return if error
    lda ($48),y
    tax
    iny
    lda #$20
    sta ($48),y ;set error in case of mismatch
    cpx #4 ;if format then we are done
    clc
    beq setvol
reqvol
    lda #d1s1id ;self-modified, requested volume
curvol
    cmp #d1s1id ;self-modified, volume of disk in drive
    sec
    bne setvol
continue
    jsr $bd04 ;complete request
              ;$BD04 avoids the need to reload A and Y
    bcs setvol

    ;watch for reads of our sector.  We will "stealth" our ID byte
    ldy #4
    lda ($48),y
    cmp #track
    bne nostealth
    iny
    lda ($48),y
    cmp #sector
    bne nostealth
!if samebyte=0 {
    ldx #sides
-   dex
    lda curvol+1 ;find the volume ID entry
    cmp idarray,x
    bne -
    lda orgarray,x ;replace volume ID byte with original byte
    ldy #0
} else {
    lda #idbyte
  !if idbyte=0 {
    tay
  } else {
    ldy #0
  }
}
    sta ($3e),y
nostealth
    clc
setvol
    ldy #3
    lda reqvol+1
    sta ($48),y
    ldy #$0e
    lda curvol+1
    sta ($48),y
    rts

    ;exchange fields
    ;track, sector, operation

callrwts
    jsr $bd04 ;read (or write) volume ID
              ;$BD04 avoids the need to reload A and Y
    ;fall through
exchange
    ldx #(newinfo_e-newinfo)-2
-   ldy newinfo+1,x
    lda ($48),y
    pha
    lda newinfo,x
    sta ($48),y
    pla
    sta newinfo,x
    dex
    dex
    bpl -
    rts

newinfo
reqop
    !byte 1, 12, >curvol+1, 9, <curvol+1, 8, sector, 5, track, 4
newinfo_e

!if samebyte=0 {
idarray
    !byte $FE, 1, 2, 3
orgarray
    !byte 0, $93, $84, $1C
}